% sparse Bayesian adaptive methods - example script
clc; clear; close all; format compact; format long eng;

Npackets = 50;
Niters = 1000; % packet length
N = 64; % filter length
T = 8; % number of nonzero coefficients
SNR_dB = 15;
ffact = .99; % forgetting factor

nmse_rls = zeros(Niters,Npackets);
nmse_garls = zeros(Niters,Npackets);
nmse_avssbl = zeros(Niters,Npackets);
nmse_avlsbl = zeros(Niters,Npackets);
nmse_avmlsbl = zeros(Niters,Npackets);

time_rls = 0;
time_garls = 0;
time_avssbl = 0;
time_avlsbl = 0;
time_avmlsbl = 0;

for q = 1 : Npackets
    
    q
    
    % channel
    Nperm = randperm(N);
    h = zeros(N,Niters);
    for i = 1 : T
        h(Nperm(i),:) = randn(1) * ones(Niters,1);
    end
    
    hl2sq = sum(h.^2);
       
    % symbols
    x = sign(randn(Niters,1));
    
    % define the convolution matrix Phi and the input
    y = zeros(Niters,1);
    Phi = zeros(N,Niters);
    tmp = zeros(N,1);
    for t = 1 : Niters
        tmp = [tmp(2:N); x(t)];
        Phi(:,t) = tmp;
        y(t) = tmp.' * h(:,t);
    end
    
    % add noise
    y_pow = y.' * y / Niters;
    n_pow = y_pow / 10^(SNR_dB/10);
    n = sqrt(n_pow) * randn(Niters,1);
    y = y + n;
    
    % adaptive rls
    tic;
    [w_rls,~] = my_rls(y,Phi,ffact);
    nmse_rls(:,q) = 10*log10(sum((h - w_rls).^2) ./ hl2sq) ;
    time_rls = time_rls + toc;
    
    % genie - aided adaptive rls
    tic;
    [w_garls,~] = my_garls(y,Phi,Nperm(1:T),ffact);
    nmse_garls(:,q) = 10*log10(sum((h(Nperm(1:T),:) - w_garls).^2) ./ hl2sq) ;
    time_garls = time_garls + toc;
        
    % adaptive variational Studet-t sparse Bayesian learning
    tic;
    [w_avssbl, ~] = my_avssbl(y,Phi,ffact,1e-6,1e-6,1e-6,1e-6);
    nmse_avssbl(:,q) = 10*log10(sum((h - w_avssbl).^2) ./ hl2sq) ;
    time_avssbl = time_avssbl + toc;
    
    % adaptive variational Laplace sparse Bayesian learning
    tic;
    [w_avlsbl, ~] = my_avlsbl(y,Phi,ffact,1e-6,1e-6,1e-6,1e-6);
    nmse_avlsbl(:,q) = 10*log10(sum( (h - w_avlsbl).^2) ./ hl2sq) ;
    time_avlsbl = time_avlsbl + toc;
    
    % adaptive variational multiparameter Laplace sparse Bayesian learning
    tic;
    [w_avmlsbl, ~] = my_avmlsbl(y,Phi,ffact,1e-6,1e-6,1e-6,1e-6);
    nmse_avmlsbl(:,q) = 10*log10(sum( (h - w_avmlsbl).^2) ./ hl2sq) ;
    time_avmlsbl = time_avmlsbl + toc;
end

nmse_rlsf = mean(nmse_rls,2);
nmse_garlsf = mean(nmse_garls,2);
nmse_avssblf = mean(nmse_avssbl,2);
nmse_avlsblf = mean(nmse_avlsbl,2);
nmse_avmlsblf = mean(nmse_avmlsbl,2);

figure;
grid on;
hold on;
ms = 3;lw = 1.2;
set(gca,'FontSize',12,'FontWeight','Normal','Box','On','FontName','Times')
plot(1:Niters, nmse_rlsf,'-g','markersize',ms, 'linewidth',lw);
plot(1:Niters, nmse_garlsf,'-.r', 'markersize',ms, 'linewidth',lw);
plot(1:Niters, nmse_avssblf,'-', 'Color',[.96 .72 0], 'linewidth',lw);
plot(1:Niters, nmse_avlsblf,'-.c','markersize',ms, 'linewidth',lw);
plot(1:Niters, nmse_avmlsblf,'--','Color',[0 .5 0], 'markersize',ms, 'linewidth',lw);
hold off;
tmp1 = legend('RLS','GARLS','ASVB-S','ASVB-L','ASVB-mpL');
set(tmp1, 'Interpreter','Latex');
xlabel('Iterations $(n)$','Interpreter','Latex','FontSize',12);
ylabel('NMSE(dB)');


fprintf('RLS elapsed time: %f \nGARLS elapsed time: %f \nAVSSSBL elapsed time: %f \nAVLSBL elapsed time: %f \nAVMLSBL elapsed time: %f \n',time_rls, time_garls, time_avssbl, time_avlsbl, time_avmlsbl);

