function [w_avssbl, beta] = my_avssbl(y,Phi,ffact,rho,delta,a_InvGamma,b_InvGamma)

% Implementation of the adaptive Bayesian Compressive Sensing algorithm
% Inputs are
%  y : channel input
%  Phi : convolution matrix of the transmitted symbols
%  aVita : 
%  bVita : 
%  a_InvGamma : 
%  b_InvGamma : 

[N,Nt] = size(Phi);

% indexes to be used in for loop for w_{\neg i}
Ndx = zeros(N,N-1); for j = 1 : N, ndx = 1:N; ndx(j) = []; Ndx(j,:) = ndx; end

alphai = ones(N,1);
alphai_old = ones(N,1);
beta = zeros(Nt,1);
w_tmp = 1e-6*ones(N,Nt);
R =  2 * eye(N);
Rphiy = zeros(N,1);
ysq = 0;
sigma_tmp = ones(N,1);

for t = 1 : Nt
    
    Rphiy = ffact *  Rphiy + Phi(:,t) * y(t);
    R  = ffact * R - ffact * diag(alphai_old) + (Phi(:,t) * Phi(:,t).') + diag(alphai);
            
    ysq = ffact * ysq + y(t)^2;
    %enrg = ysq - Rphiy.' * w_tmp(:,t);
    
    % compute the mean of gamma distribution of vita
    % beta = (aVita + 1/(1-ffact) ) / (enrg + bVita);
    beta(t) = (2* rho + N + 1/(1-ffact) ) / (ysq - Rphiy' * w_tmp(:,t) + sigma_tmp.' * diag(R) + 2 * delta);
    sigma_tmp = beta(t)^-1 * diag(R).^-1;
    
    % compute the mean of the normal distribution of w
    for j = 1 : N
        w_tmp(j,t) = R(j,j)^-1 * (Rphiy(j) - R(j,Ndx(j,:)) * w_tmp(Ndx(j,:),t));
    end
    
    % compute the mean of gamma distribution of vita
    %beta = (aVita + N + 1/(1-ffact) ) / (enrg + N/beta + bVita);
    %beta = ( 1/(1-ffact) ) / (enrg );
    
    % Compute inverse gamma (alpha's in Shutin's paper)
    %igm_old =igm;
    %igm = (a_InvGamma+.5)./ (b_InvGamma + .5 * beta*(w_tmp(:,t).^2 + (1/beta)*(1./diag(Sigma_inv)))); % With (1/beta(t))*(1./dS) we approximate the diagonal elements of the covariance matrix Sigma
    alphai_old = alphai;
    alphai = (a_InvGamma+1)./  ( b_InvGamma + beta(t) * w_tmp(:,t).^2 + 1./diag(R) );
    
    w_tmp(:,t+1) = w_tmp(:,t);
end

w_avssbl = w_tmp(:,1:Nt);

% see my_adbcs as a starting point