function [w_Rls,e_Rls] = my_rls(y,Phi,ffact)

% Implementation of the RLS algorithm
% Inputs are
%  y : channel input
%  Phi : convolution matrix of the transmitted symbols
%  ffact : forgetting factor

[N,Nt] = size(Phi);

e_Rls = zeros(Nt,1);
P_Rls = eye(N);
w_Rls = zeros(N,Nt);

% first iteration
e_Rls(1) = y(1) - Phi(:,1).' * w_Rls(:,1);
k_Rls = (ffact^-1 * P_Rls * Phi(:,1)) / (1 + ffact^-1 * Phi(:,1).' * P_Rls * Phi(:,1));
w_Rls(:,1) = k_Rls * e_Rls(1);
P_Rls = ffact^-1 * P_Rls - ffact^-1 * k_Rls * Phi(:,1).' * P_Rls;

% remaining iterations
for t = 2 : Nt
    e_Rls(t) = y(t) - Phi(:,t).' * w_Rls(:,t-1);
    k_Rls = (ffact^-1 * P_Rls * Phi(:,t)) / (1 + ffact^-1 * Phi(:,t).' * P_Rls * Phi(:,t));
    w_Rls(:,t) = w_Rls(:,t-1) + k_Rls * e_Rls(t);
    P_Rls = ffact^-1 * P_Rls - ffact^-1 * k_Rls * Phi(:,t).' * P_Rls;
end