function [w_GaRls,e_GaRls] = my_garls(y,Phi,sup,ffact)

% Implementation of the Genie-Aided Adaptive RLS algorithm
% Inputs are
%  y : channel input
%  Phi : convolution matrix of the transmitted symbols
%  ffact : forgetting factor
%  sup : the correct support set 

Nt = size(Phi,2);
T = length(sup);

e_GaRls = zeros(Nt,1);
P_GaRls = eye(T);
w_GaRls = zeros(T,1);

% first iteration
e_GaRls(1) = y(1) - Phi(sup,1).' * w_GaRls(:,1);
k_GaRls = (ffact^-1 * P_GaRls * Phi(sup,1)) / (1 + ffact^-1 * Phi(sup,1).' * P_GaRls * Phi(sup,1));
w_GaRls(:,1) = k_GaRls * e_GaRls(1);
P_GaRls = ffact^-1 * P_GaRls - ffact^-1 * k_GaRls * Phi(sup,1).' * P_GaRls;

% remaining iterations
for t = 2 : Nt
    e_GaRls(t) = y(t) - Phi(sup,t).' * w_GaRls(:,t-1);
    k_GaRls = (ffact^-1 * P_GaRls * Phi(sup,t)) / (1 + ffact^-1 * Phi(sup,t).' * P_GaRls * Phi(sup,t));
    w_GaRls(:,t) = w_GaRls(:,t-1) + k_GaRls * e_GaRls(t);
    P_GaRls = ffact^-1 * P_GaRls - ffact^-1 * k_GaRls * Phi(sup,t).' * P_GaRls;
end

